/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.registration.ModelFluidAttributes;

public class FluidTextureModel
implements IUnbakedGeometry<FluidTextureModel> {
    public static Loader LOADER = new Loader();
    private final int color;

    private static boolean isMissing(class_4730 material) {
        return class_1047.method_4539().equals((Object)material.method_24147());
    }

    private static void getTexture(class_793 owner, String name, Collection<class_4730> textures, Set<Pair<String, String>> missingTextureErrors) {
        class_4730 material = owner.method_24077(name);
        if (FluidTextureModel.isMissing(material)) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)name, (Object)owner.field_4252));
        }
        textures.add(material);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        class_4730 still = owner.method_24077("still");
        class_4730 flowing = owner.method_24077("flowing");
        class_4730 overlay = owner.method_24077("overlay");
        class_2960 overlayLocation = FluidTextureModel.isMissing(overlay) ? null : overlay.method_24147();
        class_1087 baked = new class_1093.class_1094(owner.method_3444(), owner.method_24298().method_24299(), true, owner.method_3443(), overrides).method_4747(spriteGetter.apply(still)).method_4746();
        return new Baked(baked, still.method_24147(), flowing.method_24147(), overlayLocation, this.color);
    }

    public FluidTextureModel(int color) {
        this.color = color;
    }

    private static class Baked
    extends ForwardingBakedModel {
        private final class_2960 still;
        private final class_2960 flowing;
        private final class_2960 overlay;
        private final int color;

        public Baked(class_1087 originalModel, class_2960 still, class_2960 flowing, @Nullable class_2960 overlay, int color) {
            this.wrapped = originalModel;
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.color = color;
        }

        public class_2960 getStill() {
            return this.still;
        }

        public class_2960 getFlowing() {
            return this.flowing;
        }

        public class_2960 getOverlay() {
            return this.overlay;
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class Loader
    implements IGeometryLoader<FluidTextureModel>,
    ModelFluidAttributes.IFluidModelProvider,
    SimpleSynchronousResourceReloadListener {
        private final Map<class_3611, Baked> modelCache = new ConcurrentHashMap<class_3611, Baked>();

        private Loader() {
        }

        @Nullable
        private Baked getFluidModel(class_3611 fluid) {
            return ModelHelper.getBakedModel(fluid.method_15785().method_15759(), Baked.class);
        }

        @Nullable
        private Baked getCachedModel(class_3611 fluid) {
            return this.modelCache.computeIfAbsent(fluid, this::getFluidModel);
        }

        @Override
        @Nullable
        public class_2960 getStillTexture(class_3611 fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getStill();
        }

        @Override
        @Nullable
        public class_2960 getFlowingTexture(class_3611 fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getFlowing();
        }

        @Override
        @Nullable
        public class_2960 getOverlayTexture(class_3611 fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? null : model.getOverlay();
        }

        @Override
        public int getColor(class_3611 fluid) {
            Baked model = this.getCachedModel(fluid);
            return model == null ? -1 : model.getColor();
        }

        public void method_14491(class_3300 resourceManager) {
            this.modelCache.clear();
        }

        public FluidTextureModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            int color = -1;
            if (modelContents.has("color")) {
                String colorString = class_3518.method_15265((JsonObject)modelContents, (String)"color");
                int length = colorString.length();
                if (colorString.charAt(0) == '-' || length != 6 && length != 8) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
                try {
                    color = (int)Long.parseLong(colorString, 16);
                    if (length == 6) {
                        color |= 0xFF000000;
                    }
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
            }
            return new FluidTextureModel(color);
        }

        public class_2960 getFabricId() {
            return Mantle.getResource("fluid_texture_model_loader");
        }
    }
}

